﻿using System.ComponentModel.DataAnnotations;
using System.Linq;
using PpmsDataService.Models;
using PpmsDataService.ModelsEnumTypes;

namespace PpmsDataService.Models
{
    public class CareSite
    {
        //General Info
        [Key]
        public string Name { get; set; }      
        
        public CareSiteType CareSiteType { get; set; }

        public bool VaCareSite { get; set;}

        public string SiteContactName { get; set; }

        public string OwningOrganizationName { get; set; }

        public string OtherName { get; set; }

        public bool IsHandicapAccessible { get; set; }

        public bool IsExternal { get; set; }

        //Address
        public string Street { get; set; }


        public string City { get; set; }

  
        public string State { get; set; }

        public string ZipCode { get; set; }

        public string County { get; set; }

        public string Country { get; set; }

        public string Latitude { get; set; }

        public string Longitude { get; set; }

        public bool Geocoded { get; set; }

        //VA Site Info. 
        public string Visn { get; set; }

        public string Facility { get; set; }

        public string ParentStationNumber { get; set; }

        public string StationNumber { get; set; }

        public string StationName { get; set; }

        public string MainSitePhone { get; set; }

        public virtual IQueryable<Provider> OwningOrganization { get; set; }

        public virtual IQueryable<Provider> Providers { get; set; }

        public virtual IQueryable<ProviderService> ProviderServices { get; set; }

        public virtual IQueryable<ProviderPrivilege> ProviderPrivileges { get; set; }

        public virtual IQueryable<VaProviderRelationship> VaProviderRelationships { get; set; }

        public virtual IQueryable<ProviderContact> SiteContact { get; set; }
    }
}